//
//  NewRegistrationViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 20.02.23.
//

import UIKit

class NewRegistrationViewController : UIViewController {
    
    
    @IBOutlet var qualtricsHeaderLabel: UILabel!
    @IBOutlet var qualtricsDetailsLabel: UILabel!
    @IBOutlet var qualtricsURLLabel: UILabel!
    
    @IBOutlet var newRegistrationHeaderLabel: UILabel!
    @IBOutlet var newRegistrationDetailsLabel: UILabel!
    @IBOutlet var newRegistrationButton: UIButton!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.black,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        self.navigationController?.navigationBar.titleTextAttributes = [NSAttributedString.Key.foregroundColor: UIColor.black]
        
        newRegistrationButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 16)
        
        
        qualtricsHeaderLabel.textColor = Colors.greyColor
        qualtricsHeaderLabel.font = Fonts.heavyFontWithSize(size: 17)
        qualtricsHeaderLabel.text = "Hinweis"
        
        var textArray_qualtricsDetailsLabel = [String]()
        var fontArray_qualtricsDetailsLabel = [UIFont]()
        var colorArray_qualtricsDetailsLabel = [UIColor]()
        
        textArray_qualtricsDetailsLabel.append("Wenn Sie über Ihren Computer oder Laptop an der")
        textArray_qualtricsDetailsLabel.append("Qualtrics-Umfrage")
        textArray_qualtricsDetailsLabel.append("teilnehmen, nutzen Sie bitte die")
        textArray_qualtricsDetailsLabel.append("App-PIN aus der Szenariobeschreibung.")
        
        
        fontArray_qualtricsDetailsLabel.append(Fonts.mediumFontWithSize(size: 16.0))
        fontArray_qualtricsDetailsLabel.append(Fonts.heavyFontWithSize(size: 16.0))
        fontArray_qualtricsDetailsLabel.append(Fonts.mediumFontWithSize(size: 16.0))
        fontArray_qualtricsDetailsLabel.append(Fonts.heavyFontWithSize(size: 16.0))
        
        colorArray_qualtricsDetailsLabel.append(Colors.greyColor)
        colorArray_qualtricsDetailsLabel.append(Colors.carmine)
        colorArray_qualtricsDetailsLabel.append(Colors.greyColor)
        colorArray_qualtricsDetailsLabel.append(Colors.carmine)
        
        self.qualtricsDetailsLabel.attributedText = getAttributedString(arrayText: textArray_qualtricsDetailsLabel, arrayColors: colorArray_qualtricsDetailsLabel, arrayFonts: fontArray_qualtricsDetailsLabel)
        
        
        newRegistrationHeaderLabel.textColor = Colors.greyColor
        newRegistrationHeaderLabel.font = Fonts.heavyFontWithSize(size: 16)
        newRegistrationHeaderLabel.text = "Neu registrieren"
        
        newRegistrationDetailsLabel.textColor = Colors.greyColor
        newRegistrationDetailsLabel.font = Fonts.mediumFontWithSize(size: 16)
        newRegistrationDetailsLabel.text = "Alternativ können Sie über den folgenden Link an der Umfrage teilnehmen. Bitte öffnen Sie diesen auf einem Computer oder Laptop:"
        
        qualtricsURLLabel.textColor = Colors.greyColor
        qualtricsURLLabel.font = Fonts.mediumFontWithSize(size: 16)
        qualtricsURLLabel.text = "bit.ly/hcs_onlinebanking"
        
        
        self.view.backgroundColor = UIColor(red: 255.0, green: 255.0, blue: 255.0, alpha: 1.0) //.withAlphaComponent(0.5)
        
    }
    
    //MARK:- getAttributedString
    func getAttributedString(arrayText:[String]?, arrayColors:[UIColor]?, arrayFonts:[UIFont]?) -> NSMutableAttributedString {
        
        let finalAttributedString = NSMutableAttributedString()
        
        for i in 0 ..< (arrayText?.count)! {
            
            let attributes = [NSAttributedString.Key.foregroundColor: arrayColors?[i], NSAttributedString.Key.font: arrayFonts?[i]]
            let attributedStr = (NSAttributedString.init(string: arrayText?[i] ?? "", attributes: attributes as [NSAttributedString.Key : Any]))
            
            if i != 0 {
                
                finalAttributedString.append(NSAttributedString.init(string: " "))
            }
            
            finalAttributedString.append(attributedStr)
        }
        
        return finalAttributedString
    }
    
    @IBAction func closeButton(_ sender: Any) {
        self.dismiss(animated: true)
    }
    
    @IBAction func appPINButton(_ sender: Any) {
        
    }
    
}
